//ACT Objects - for game vents data: chests, plot related events events, etc.


function ChestOpen(ChestNum, ItemNum, Quantity)
{
 if (Quantity == null)
  {Quantity = 1}
  
 if ( ActData.chestsOpened[ChestNum] == false )
 {
  SetPersonFrame( GetCurrentPerson(), 1)
  OpenChest(ItemNum,Quantity)
  ActData.chestsOpened[ChestNum] = true
 }
}

function CombatChest(ChestNum, ItemNum, Quantity, fightNum)
{
 Text = "A monster leaps out of the chest!"
 if (Quantity == null)
  {Quantity = 1}
  
 if ( ActData.chestsOpened[ChestNum] == false )
 {
  SetPersonFrame( GetCurrentPerson(), 1)
  ChestMessage(Text)
  fightIntro(fightNum)
  OpenChest(ItemNum,Quantity)
  ActData.chestsOpened[ChestNum] = true
 }
}

function LoadActData()
{
ActData = new Object;
ActData.chestsOpened = new Array;
ActData.chestsOpened[0] = false //1st Forest chest. -Contains Silver Ring
ActData.chestsOpened[1] = false //2nd Forest chest - contains stone tablet
ActData.chestsOpened[2] = false //3rd Forest chest - cure potions.
ActData.chestsOpened[3] = false //Chest on roof of Nishi Castle
ActData.chestsOpened[4] = false //1st Chest in Temple (Temple1-02.rmp)
ActData.chestsOpened[5] = false // 2nd Chest in Temple (Temple1-03.rmp)
ActData.chestsOpened[6] = false // 3rd Chest in Temple (Temple1-03.rmp)
ActData.chestsOpened[7] = false // 4th Chest in Temple (Temple1-03.rmp)
ActData.chestsOpened[8] = false // 5th Chest in Temple (Temple1-03.rmp)
ActData.chestsOpened[9] = false // 6th Chest in Temple (Temple1-03.rmp)

//---------------------------------------------------------ACT2------------------
ActData.chestsOpened[10] = false //1st chest in earth cave
ActData.chestsOpened[11] = false //2nd chest in earth cave
ActData.chestsOpened[12] = false //3rd chest in earth cave
ActData.chestsOpened[13] = false //4th chest in earth cave

ActData.chestsOpened[14] = false //1st chest in earth cave 2nd floor
ActData.chestsOpened[15] = false //2nd chest in earth cave 2nd floor
ActData.chestsOpened[16] = false //3rd chest in earth cave 2nd floor

ActData.chestsOpened[17] = false //1st chest in Burning village
ActData.chestsOpened[18] = false //2nd chest in Burning village

ActData.chestsOpened[19] = false //Astral lv2 chest1
ActData.chestsOpened[20] = false //Astral lv2 chest2
ActData.chestsOpened[21] = false //Astral lv2 chest3
ActData.chestsOpened[22] = false //Astral lv3 chest1
ActData.chestsOpened[23] = false //Astral lv3 chest2
ActData.chestsOpened[24] = false //Astral lv3 chest3
ActData.chestsOpened[25] = false //Astral lv3 chest4
ActData.chestsOpened[26] = false //Astral lv4 chest1
ActData.chestsOpened[27] = false //Astral lv4 chest2

ActData.chestsOpened[28] = false //Extra Chest 1 in Dark Forest
ActData.chestsOpened[29] = false //Extra Chest 1 Cave level 3


//Events may not all be in the order they occur...
ActData.EventsTriggers = new Array;
ActData.EventsTriggers[0] = false // Intro Screen up to 1st comment in town1
ActData.EventsTriggers[1] = false // Talk on entering the 1st Inn
ActData.EventsTriggers[2] = false // Beslan joins party
ActData.EventsTriggers[3] = false // turn off the rain.
ActData.EventsTriggers[4] = false // bandits attack!
ActData.EventsTriggers[5] = false // Exit the forest...
ActData.EventsTriggers[6] = false // Guy Walks you to the Inn...
ActData.EventsTriggers[7] = false // dialogue at the entrance of the forest.
ActData.EventsTriggers[8] = false // Forest Switch (with posts/spike things) is ON.
//EventsTriggers[23] comes next in the game..
ActData.EventsTriggers[9] = false // Conversation about Tablet in Forest.
ActData.EventsTriggers[10] = false // Conversation after Bandits are dead.
ActData.EventsTriggers[11] = false // Turned on queues the conversation outside the forest.
ActData.EventsTriggers[12] = false // conversation outside the forest.
ActData.EventsTriggers[13] = false // Camping On the way to the castle.
//--In the Castle------------------------------------------------------------------
ActData.EventsTriggers[14] = false // Talking to the castle guards.
ActData.EventsTriggers[15] = false // Big Talk with the king. Cain Joins
ActData.EventsTriggers[16] = false // Switch in Temple lv3.
ActData.EventsTriggers[17] = false // BossFight trigger.
ActData.EventsTriggers[18] = false // Get 2nd tablet

//-------------------------------------------------------------ACT2------------------
ActData.EventsTriggers[19] = false // Talk to King again in castle...
ActData.EventsTriggers[20] = false // Earth Cave boss fight...
ActData.EventsTriggers[21] = false // End of Demo Message...
ActData.EventsTriggers[22] = false // End of Demo Message...
ActData.EventsTriggers[23] = false // Extra dialogue back in Dark Woods...
ActData.EventsTriggers[24] = false // freeing Beslan's Dad...
ActData.EventsTriggers[25] = false // Bandit Attack pt1 - pair of bandits
ActData.EventsTriggers[26] = false // Bandit Attack pt2 - burning barrier
ActData.EventsTriggers[27] = false // Bandit Attack pt3 - Bandits Defeated. 
ActData.EventsTriggers[28] = false // Talk with Delanu, town restored.
ActData.EventsTriggers[29] = false // Go into the void / astral place.

//------------------------------------------------------EXTRA CASTLE EVENTS

ActData.EventsTriggers[30] = false // Dialogue outside Nishi Castle
ActData.EventsTriggers[31] = false // eXTRA dialogue in temple1 
ActData.EventsTriggers[32] = false // Interlude in Forest
//----------------------------------------------------ASTRAL
ActData.EventsTriggers[33] = false // Platform1 - astral l2
ActData.EventsTriggers[34] = false // Platform2
ActData.EventsTriggers[35] = false // Platform3
ActData.EventsTriggers[36] = false // Platform4
ActData.EventsTriggers[37] = false // Platform5
ActData.EventsTriggers[38] = false // Platform6
ActData.EventsTriggers[39] = false // Platform7
ActData.EventsTriggers[40] = false // Platform8
ActData.EventsTriggers[41] = false // Platform9
ActData.EventsTriggers[42] = false // Platform10
ActData.EventsTriggers[43] = false // Switch1 - left
ActData.EventsTriggers[44] = false // Switch2 - right
ActData.EventsTriggers[45] = false // Platform11
ActData.EventsTriggers[46] = false // Platform12
ActData.EventsTriggers[47] = false // Astral Boss
ActData.EventsTriggers[48] = false // Tablet
//---------------------------------------------EXTRA AUTUMN FOREST / ASTRAL  EVENTS
ActData.EventsTriggers[49] = false // camp notice oustide earthcave.
ActData.EventsTriggers[50] = false // "We gotta help the tonspeople"

ActData.EventsTriggers[51] = false // Astral - ominous lights1
ActData.EventsTriggers[52] = false // Astral - ominous lights2
ActData.EventsTriggers[53] = false // Astral - ominous lights3


thiefCounter =  new Object;
thiefCounter.count = 0;
}


function Event04 ()//BADNITS ON THE BRIDGE..
{
if ( ActData.EventsTriggers[4] == false)
 {
  MovieCrop.turnOn()

  CreatePerson('B01', 'thieves.rss', true)
  CreatePerson('B02', 'thieves.rss', true)
  SetPersonLayer('B01', 02)
  SetPersonLayer('B02', 02)
  SetPersonSpeed('B01', 3)
  SetPersonSpeed('B01', 3)
  
  SetPersonX('B01', 2820)
  SetPersonY('B01', 2970)
  SetPersonX('B02', 2430)
  SetPersonY('B02', 3200)

 goNorth('B01')
 goWest('B01')
 goSouthwest('B01')
 
 goEast('B02')
 goNorth('B02')
 QueuePersonCommand('B01', COMMAND_FACE_SOUTH, 0)
 EventCatchUp('B01')
 
 //Event04()
 //Event04b()
 //SetDelayScript(40, "Event04b()")


var talkString = 'Stop right there!'
var port = 'port10.png'
 
 Talk_Window(talkString,port);
 Delay(200);

 //while (IsCommandQueueEmpty('B01') == false)
 // {waitForMap() }//This Waits for the Chars to finish moving, before proceeding with the script.
  
 Talk_Window(talkSet[3][13], CharRoot[0].portrait);
 Delay(200);
 Talk_Window(talkSet[3][14], CharRoot[1].portrait,1);
 Delay(200);
  Talk_Window(talkSet[3][15], CharRoot[0].portrait);
 Delay(200);
  Talk_Window(talkSet[3][16], port);
 Delay(200);
  Talk_Window(talkSet[3][17], CharRoot[0].portrait,1);
 Delay(200);
  Talk_Window(talkSet[3][18], port);
 Delay(200);
  Talk_Window(talkSet[3][19], CharRoot[0].portrait,1);
 Delay(200);
  Talk_Window(talkSet[3][20], port);
 Delay(200);
  Talk_Window(talkSet[3][21], CharRoot[1].portrait,1);
 Delay(200);
  Talk_Window(talkSet[3][22], CharRoot[0].portrait);
 Delay(200);
  
 eatKey()
 fightIntro(901, true);
 DestroyPerson("B02")
 DestroyPerson("B01")
 MovieCrop.turnOff()
 T = 0
 
 ActData.EventsTriggers[4] = true
 event10()
 }//end biiiig if.
}

function waitForMap()
{
 RenderMap() 
 FlipScreen();
 UpdateMapEngine()
}

//-------------------------------------------Events Ordered by MapName------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------


//---------TOWN 01-----------------------------------------------------------------------
function event0()
{ 
  //MovieCrop.turnOff()
  Talk_Window(talkSet[0][0],Char[0].portrait)
  //SetDelayScript(50, " Talk_Window(talkSet[0][0],Char[0].portrait ) ")
  ActData.EventsTriggers[0] = true
}

function event1()
{
 Talk_Window(talkSet[1][0],Char[0].portrait )
  eatKey()  
 Talk_Window(talkSet[1][1],'port13.png')
  eatKey()  
 Talk_Window(talkSet[1][13],Char[0].portrait)//on purpose...
  eatKey() 
 Talk_Window(talkSet[1][2],'port13.png')
  eatKey()  
 Talk_Window(talkSet[1][3], Char[0].portrait)
  eatKey()   
ActData.EventsTriggers[1] = true
ActData.EventsTriggers[6] = true
}




function event2()
{
 var Port =  CharRoot[1].portrait
  Talk_Window(talkSet[1][4],Char[0].portrait );
   eatKey()
  Talk_Window(talkSet[1][5],Port,1);
   eatKey()
  Talk_Window(talkSet[1][6],Char[0].portrait );
   eatKey()
  Talk_Window(talkSet[1][7],Port,1);
   eatKey()
  Talk_Window(talkSet[1][8],Char[0].portrait);
   eatKey()
  Talk_Window(talkSet[1][9],Port,1);
   eatKey()
  Talk_Window(talkSet[1][10],Char[0].portrait);
   eatKey()
  Talk_Window(talkSet[1][11],Port,1);
   eatKey()
  Talk_Window(talkSet[1][12],Char[0].portrait);
   eatKey()
  JoinScreen(1)//Beslan Joins...
  Delay(200);
  eatKey()
  
  
 LoadChar(CharRoot[1])
 who =  CharRoot[1]
 equipStats()
 DestroyPerson("Beslan1")
 ActData.EventsTriggers[2] = true
 CreatePartySprites()
 
}
 
 
function event6() // Being guided to the Inn...
{
 var Port= "port11.png"
 
 SetPersonSpeed('guide', WalkSpeed)
 Talk_Window(talkSet[0][1],Port)
 eatKey()
  Talk_Window(talkSet[0][2],Char[0].portrait)
 eatKey()
  Talk_Window(talkSet[0][3],Port)
 eatKey()
  Talk_Window(talkSet[0][4],Char[0].portrait)
 eatKey()
  Talk_Window(talkSet[0][5],Port)
 eatKey()
  Talk_Window(talkSet[0][6],Char[0].portrait)
 eatKey()
  Talk_Window(talkSet[0][7],Port)
 eatKey()
  Talk_Window(talkSet[0][8],Char[0].portrait)
 eatKey()
  Talk_Window(talkSet[0][9],Port)
 eatKey()
 
DetachControl()
IgnorePersonObstructions(WalkList[0], 1)
IgnorePersonObstructions('guide', 1)
GotoPoint(GetPersonX('guide'),GetPersonY('guide'), WalkList[0])
goSouth('guide',1)
EventCatchUp('guide')
//FollowPerson(WalkList[0], 'guide', 50)
QueuePersonCommand('guide', COMMAND_FACE_SOUTH,true)
goSouth('guide',8)
goSouth(WalkList[0],9)
goWest('guide',6.5)
goWest(WalkList[0],6.5)

QueuePersonScript('guide', "ClearPersonCommands(WalkList[0])", false)
//QueuePersonScript('guide', "FollowPerson(WalkList[0], '', 0)", false)
QueuePersonScript('guide', "returnControl(WalkList[0])", false)
goWest('guide',1)
QueuePersonCommand('guide', COMMAND_FACE_EAST,true)
QueuePersonScript('guide',"Talk_Window(talkSet[0][10],MapPeople[4].Port )",false)
QueuePersonScript('guide',"Talk_Window(talkSet[0][11],Char[0].portrait  )",false)
QueuePersonScript('guide',"IgnorePersonObstructions(WalkList[0], 0)",false)
QueuePersonScript('guide',"IgnorePersonObstructions('guide', 0)",false)
//EventCatchUp('guide')
//IgnorePersonObstructions(WalkList[0], 0)
//IgnorePersonObstructions('guide', 0)
}


//---------Forest 01-----------------------------------------------------------------------
function event7()
{

 

if ( ActData.EventsTriggers[7] == false && ActData.EventsTriggers[2] == true )
  {
   Talk_Window(talkSet[3][0], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[3][1],Char[1].portrait,1);
   eatKey()
   ActData.EventsTriggers[7] = true
 }
}


function event8A() //At the Fence
{
  Talk_Window(talkSet[3][2], Char[1].portrait);
  eatKey()
  Talk_Window(talkSet[3][3], Char[0].portrait);
  eatKey()
  ActData.EventsTriggers[23] = true
}
function event8B() //At the Tree Switch
{
  Talk_Window(talkSet[3][4], Char[1].portrait);
  eatKey()
  
  
  YesNoSwitch = new DMenu
  YesNoSwitch.setItem ("Yes");
  YesNoSwitch.setItem ("No");
  YesNoSwitch.setDraw(RenderMap)
 
  var Choice = YesNoSwitch.execute (250,350,300,80, "Hit the switch?")
  switch (Choice)
   {
     case null:
      close = true
      break;
     
     case 0:
			 Talk_Window(talkSet[3][5], Char[0].portrait);
			 eatKey()
			 chestSound.play(0)
			 event8C()
			 ActData.EventsTriggers[8] = true
		 break;
		 
		 case 1:
			 Talk_Window("Let's not.", Char[1].portrait);
			 eatKey()

		 break;
	}
}

function event8C()//Change Post tiles in forest to allow passage.
{
		   SetTile(10, 52, 2, 81) ;
		   SetTile(11, 53, 2, 81) ;
		   SetTile(12, 54, 2, 81) ;

		   SetTile(10, 51, 2, 0) ;
		   SetTile(11, 52, 2, 0) ;
		   SetTile(12, 53, 2, 0) ;
}

function event9()//finding the 1st tablet in the forest.
{


if ( ActData.EventsTriggers[9] == false && ActData.EventsTriggers[2] == true )
  {
   Talk_Window(talkSet[3][6], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[3][7],Char[1].portrait,1);
   eatKey()
   Talk_Window(talkSet[3][8], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[3][9],Char[1].portrait,1);
   eatKey()
   Talk_Window(talkSet[3][10], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[3][11], Char[1].portrait,1);
   eatKey()
   Talk_Window(talkSet[3][12], Char[0].portrait);
   eatKey()
   
   event9b()

  
   ActData.EventsTriggers[9] = true
 }
}

function event9b()
{
  SetTile(25, 51, 2, 81) ;
	SetTile(26, 50, 2, 81) ;

	SetTile(25, 50, 2, 0) ;
	SetTile(26, 49, 2, 0) ;
}

function event10()
{

 var IsAlive = false
 if (Char[0].alive == true || Char[1].alive == true)
	 {IsAlive = true}
if ( ActData.EventsTriggers[10] == false && IsAlive == true)
  {
   Talk_Window(talkSet[3][23], Char[1].portrait);
   eatKey()
   Talk_Window(talkSet[3][24],Char[0].portrait,1);
   eatKey()
   ActData.EventsTriggers[10] = true
 }
}

function event12()
{
 var talk1 = "So, what do we do now?"
 var talk2 = "I think we should bring that tablet to Nishi Castle. The king there is very wise. He should know where the other tablets are located."
 
 if ( ActData.EventsTriggers[11] == true  &&  ActData.EventsTriggers[12] == false)
  {
   Talk_Window(talkSet[3][25], Char[1].portrait);
   eatKey()
   Talk_Window(talkSet[3][26],Char[0].portrait,1);
   eatKey()
   Talk_Window(talkSet[3][27], Char[1].portrait);
    eatKey()
   Talk_Window(talkSet[3][28],Char[0].portrait,1);
    eatKey()
   Talk_Window(talkSet[3][29], Char[1].portrait);
    eatKey()
   Talk_Window(talkSet[3][30],Char[0].portrait,1);
    eatKey()
   Talk_Window(talkSet[3][31], Char[1].portrait);
    eatKey()
   Talk_Window(talkSet[3][32],Char[0].portrait,1);
    eatKey()
   Talk_Window(talkSet[3][33], Char[1].portrait);
    eatKey()
   Talk_Window(talkSet[3][34],Char[0].portrait,1);
    eatKey()
   Talk_Window(talkSet[3][35],Char[1].portrait,1);
    eatKey()
   Talk_Window(talkSet[3][36], Char[0].portrait);
    eatKey()
   Talk_Window(talkSet[3][37],Char[1].portrait,1);
    eatKey()
   Talk_Window(talkSet[3][38], Char[0].portrait);
    eatKey()
   Talk_Window(talkSet[3][39],Char[1].portrait,1);
    eatKey()      
   Talk_Window(talkSet[3][40], Char[0].portrait);
    eatKey()
   Talk_Window(talkSet[3][41],Char[1].portrait,1);
    eatKey()

    
    
    
   ActData.EventsTriggers[12] = true
 }
}


function event13()
{
 var talk1 = "Let's camp for the night. we won't make it to the castle today."
 var talk2 = "Those strange tablets... Unimaginable power? "
 var talk3 = "What would I need that for? Still, If I had that kind of power, I wouldn't be afraid of anyone..."
 var talk4 = "He's a strange guy. Kind of moody, I think."
 var talk5 = "But what was that tablet doing in the forest? I thought the tablets had been lost or destroyed hundreds of years ago."
              + "To find something like that just lying around, it gives me a bad feeling..."
 
 if ( ActData.EventsTriggers[13] == false)
  {
   Talk_Window(talkSet[3][42], Char[1].portrait);
    eatKey()
   Talk_Window(talkSet[3][43], Char[0].portrait,1);
    eatKey()
   
   Camp.activate()
   MainMusic.stop()
   sleepySong.play(0)   
   Talk_Window(talkSet[3][44],Char[1].portrait);
   eatKey()
   Talk_Window(talkSet[3][45], Char[0].portrait,1);
   eatKey()
   Talk_Window(talkSet[3][46],Char[1].portrait);
   eatKey()
   Talk_Window(talkSet[3][47],Char[0].portrait,1);
   eatKey()
   ActData.EventsTriggers[13] = true
   
   
   Interlude01()
   
   
   
		
 }
}

function event13b()
{
   //Camp.Wakeup()
   for (var i = 0; i < Char.length; i++)
		{
		 Char[i].alive = true
		 Char[i].HP = Char[i].maxHP
		 Char[i].MP = Char[i].maxMP   
		}
		MainMusic.play(1)
		
	 Talk_Window(talkSet[3][48],Char[1].portrait);
    eatKey()
   Talk_Window(talkSet[3][49],Char[0].portrait,1);
    eatKey() 
}

//----------------------------------------------CASTLE----------------------------------------------

function event14pre()
{
 if ( ActData.EventsTriggers[14] == false )
  {
   Talk_Window(talkSet[5][0], Char[1].portrait);
   eatKey()
   Talk_Window(talkSet[5][1],Char[0].portrait,1);
   eatKey()
  }
}


function event14()
{
//Guard01
//Guard02
 if ( ActData.EventsTriggers[14] == false)
   { 
	 var talk1 = "I'm sorry but no one is allowed to enter the castle without permission. "
	 var talk2 = "We have to be careful these days."
	 var talk3 = "I have a friend here, a knight named Cain. Can she grant us permission to enter?"
	 var talk4 = "Cain? One of the king's most trusted knights... I'll have to speak with her."
	 var talk5 = "Beslan! Good to see you again. Please come in. Who is your friend?"
	 var talk6 = "Oh, this is Aldric. We travelled through the forest together."
	 var talk7 = "I see. Well, I'll give you some time to wander around. Please come see the king later. I'm sure there are things to talk about."

	 
	  //GuardPortX = 'port11.png'
	 
	 DetachControl()
	 //MovieCrop.turnOn()
	 
	 goNorth(WalkList[0],2)
	 
	 goEast('Guard01',2)
	 goSouth('Guard01',2)
	 goWest('Guard02',2)
	 goSouth('Guard02',2)

        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][2], 'port11.png')",false)
        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][3], Char[1].portrait,1)",false)
        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][4], 'port11.png') ",false)
        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][5], Char[1].portrait, 1)",false)
        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][6], 'port11.png')",false)
        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][7], Char[1].portrait,1)",false)
        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][8], 'port11.png') ",false)
        QueuePersonScript('Guard02',"Talk_Window(talkSet[5][9], Char[1].portrait,1)",false)        
	 
	 //goNorth('Guard02',3)
	 QueuePersonScript('Guard02',"event14B()",false)
	 
	 //SetPersonX('CainNPC', GetPersonX('Guard02') )
	 //SetPersonY('CainNPC', GetPersonY('Guard02') - 60)
	 
	 //Talk_Window(talk5, CharRoot[2].portrait );
	 //eatKey()
	 
	 ActData.EventsTriggers[14] = true
   }
}

function event14B() //Second Half... Cain Arrives.
{
 SetPersonX('CainNPC', GetPersonX('Guard02') )
 SetPersonY('CainNPC', GetPersonY('Guard02') - 240)
 //waitPlease('Guard02',2)
 waitPlease('CainNPC',2)
 //goSouth('Guard02',3)
 goSouth('CainNPC',3)

 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][10], CharRoot[2].portrait)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][11], Char[1].portrait,1)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][12], CharRoot[2].portrait)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][13], Char[1].portrait,1)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][14], CharRoot[2].portrait)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][15], Char[1].portrait,1)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][16], Char[0].portrait,1)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][17], CharRoot[2].portrait)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][18], Char[0].portrait,1)",false)
 QueuePersonScript('CainNPC',"Talk_Window(talkSet[5][19], Char[1].portrait)",false) 
 
  
 goNorth('CainNPC',3)
 QueuePersonScript('CainNPC',"event14C()",false)
}

function event14C()
{
 DestroyPerson('CainNPC')
 goNorth('Guard01',2)
 goNorth('Guard02',2)
 goWest('Guard01',2)
 goEast('Guard02',2)
 QueuePersonCommand('Guard01', COMMAND_FACE_EAST,true)
 QueuePersonCommand('Guard02', COMMAND_FACE_WEST,true)
 QueuePersonScript('Guard02',"returnControl(WalkList[0])",false)
 //QueuePersonScript('Guard02',"MovieCrop.turnOff()",false) 
}


function event14D()
{
 if ( ActData.EventsTriggers[30] == false )
  {
   Talk_Window(talkSet[5][20], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[5][21], Char[1].portrait,1);
   eatKey()
   Talk_Window(talkSet[5][22], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[5][23],Char[1].portrait,1);
   eatKey()
   Talk_Window(talkSet[5][24], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[5][25],Char[1].portrait,1);
   eatKey()
   Talk_Window(talkSet[5][26], Char[0].portrait);
   eatKey()
   Talk_Window(talkSet[5][27],Char[1].portrait,1);
   eatKey()      
   
   ActData.EventsTriggers[30] = true
  }
}



function event15()
{
 if ( ActData.EventsTriggers[15] == false)
  {
   MovieCrop.turnOn()
   DetachControl()	 
   goNorth(WalkList[0],9)
   QueuePersonScript(WalkList[0], "event15b()", false) 
   ActData.EventsTriggers[30] = true  
   }
}


function event15b()
{
 var talk1 = "Welcome Aldric and Beslan. I am Balus, King of Nishi Castle. We have had few travellers of late, and I'd like to speak with you a bit."
 var talk2 = "Perhaps you've heard the news of the fighting to the north. The evil wizard Nezumi has declared his intention to unleash the "
		 +"power of the five tablets. He will use them to take control of the entire continent."
 var talk3 = "What exactly are these tablets? "
 var talk4 = "To be honest, no one knows that much about them, but they contain an immense magical force sealed inside them. In ages past "
		 +"they wreaked great destruction upon the world. For some unknown reason, they have appeared again recently, after being lost "
		 +"for over 200 years. "
 var talk5 = "I have decided to gather the tablets and keep them here in this castle, where they can be kept safe. "
		 +"We had gathered one of the tablets already, but unfortunately it was stolen."
 var talk6 = "Hmm... Did it look anything like this? "
 var talk7 = "That's it! How did you come to have it?"
 var talk8 = "I see. Probably it was hidden there by the bandits. In any case, It seems fate has guided you here."
 var talk9 = "Well, if the spirits are guiding you, I'd like to ask for your help. I would like to gather the other 4 tablets. Will you help me do this?"
 var talk10 = "Well, it sounds interesting. I'll do it.  But if we come across any other treasure in our search, it's mine!"
 var talk11 = "Fair enough. I'll send Cain with you for support. She'll be a reliable companion."
 var talk12 = "I believe the second tablet is located in the ruins of an ancient temple to the north. Please go there and retrieve it. You must go "
		 +"quickly, as the wizard's servants will be searching too."
 var talk13 = "Alright. Well, lets prepare and then head north."
 var talk14 = "Ok. I'm coming with you guys."
 
  
 var KingPort = "port12.png"
 
 if ( ActData.EventsTriggers[15] == false)
  {
     Talk_Window(talkSet[6][0], Char[1].portrait,1);
   eatKey()   
     //Talk_Window(talkSet[6][1], KingPort);//empty lne oops...
   //eatKey() 
       Talk_Window(talkSet[6][2], KingPort);
   eatKey()
     Talk_Window(talkSet[6][3], Char[1].portrait,1);
   eatKey()  
     Talk_Window(talkSet[6][4], KingPort);
   eatKey()
     Talk_Window(talkSet[6][5], Char[1].portrait,1);
   eatKey()      
     Talk_Window(talkSet[6][6], Char[0].portrait,1);
   eatKey()
     Talk_Window(talkSet[6][7], KingPort);
   eatKey()   
     Talk_Window(talkSet[6][8], Char[0].portrait,1);
   eatKey() 
     Talk_Window(talkSet[6][9], KingPort);
   eatKey()
     Talk_Window(talkSet[6][10], Char[1].portrait,1);
   eatKey()  
     Talk_Window(talkSet[6][11], KingPort);
   eatKey()
     Talk_Window(talkSet[6][12], Char[1].portrait,1);
   eatKey()      
     Talk_Window(talkSet[6][13], KingPort);
   eatKey()      
     Talk_Window(talkSet[6][14], Char[0].portrait,1);
   eatKey()   
     Talk_Window(talkSet[6][15], KingPort);
   eatKey() 
       Talk_Window(talkSet[6][16], Char[0].portrait,1);
   eatKey()
     Talk_Window(talkSet[6][17], CharRoot[2].portrait);
   eatKey()  
     Talk_Window(talkSet[6][18], KingPort);
   eatKey()
     Talk_Window(talkSet[6][19], Char[1].portrait,1);
   eatKey()      
     Talk_Window(talkSet[6][20], KingPort);
   eatKey()  
     Talk_Window(talkSet[6][21], Char[0].portrait,1);
   eatKey()   
     Talk_Window(talkSet[6][22], KingPort);
   eatKey() 
       Talk_Window(talkSet[6][23], Char[1].portrait,1);
   eatKey()
     Talk_Window(talkSet[6][24], KingPort);
   eatKey()  
     Talk_Window(talkSet[6][25], CharRoot[2].portrait);
   eatKey()
     Talk_Window(talkSet[6][26], KingPort);
   eatKey()      
     Talk_Window(talkSet[6][27], CharRoot[2].portrait);
   eatKey()  
   //---------------------------------------- 
     Talk_Window(talkSet[6][28], KingPort);
   eatKey() 
     Talk_Window(talkSet[6][29], Char[1].portrait,1);
   eatKey()
     Talk_Window(talkSet[6][30], CharRoot[2].portrait);
   eatKey()  
     Talk_Window(talkSet[6][31], KingPort);
   eatKey()
     Talk_Window(talkSet[6][32], Char[0].portrait,1);
   eatKey()      
     Talk_Window(talkSet[6][33], KingPort);
   eatKey()      
     Talk_Window(talkSet[6][34], Char[0].portrait,1);
   eatKey()   
     Talk_Window(talkSet[6][35], CharRoot[2].portrait);
   eatKey() 
       Talk_Window(talkSet[6][36], KingPort);
   eatKey()
     Talk_Window(talkSet[6][37], Char[1].portrait,1);
   eatKey()  
     Talk_Window(talkSet[6][38], KingPort);
   eatKey()
     Talk_Window(talkSet[6][39], Char[0].portrait,1);
   eatKey()      
     Talk_Window(talkSet[6][40], KingPort);
   eatKey()
		 OpenGoldChest(300) 
   eatKey()  
     Talk_Window(talkSet[6][41], Char[0].portrait,1);
   eatKey()   
     Talk_Window(talkSet[6][42], Char[1].portrait,1);
   eatKey() 
       Talk_Window(talkSet[6][43], KingPort);
   eatKey()
     Talk_Window(talkSet[6][44], CharRoot[2].portrait);
   eatKey()  
  
   Delay(100)  
   JoinScreen(2)//Cain Joins...
  
  
   returnControl(WalkList[0])
   
    LoadChar(CharRoot[2])
    who =  CharRoot[2]
    equipStats()
    levelUp(CharRoot[2], true)// New Aug 6, 2004
    
    //addItem(newitem,stock)
    CharRoot[2].equipment[0] = Itemlist[5]
    CharRoot[2].equipment[1] = Itemlist[6]
    
    
    DestroyPerson('CainNPC')   
    CreatePartySprites()
    MovieCrop.turnOff()
    ActData.EventsTriggers[15] = true
 }
}

//----------------------------TEMPLE--------------------
function event16pre()//getting scared at entrance dialogue
{
 if ( ActData.EventsTriggers[31] == false && Char.length > 2)
  {
   Talk_Window(talkSet[8][0], Char[1].portrait);
   eatKey()   
   Talk_Window(talkSet[8][1], Char[2].portrait,1);
   eatKey()     
   Talk_Window(talkSet[8][2], Char[0].portrait);
   eatKey()   
   Talk_Window(talkSet[8][3], Char[2].portrait,1);
   eatKey()         
   Talk_Window(talkSet[8][4], Char[0].portrait);
   eatKey()      
   ActData.EventsTriggers[31] = true
 }
                                              
}

function event16() //Change Post tiles in temple to allow passage.
{
SetTile(53, 38, 2, 0) ;
SetTile(53, 39, 2, 0) ;
SetTile(54, 39, 2, 0) ;
}


function event17()
{
 if ( ActData.EventsTriggers[17] == false)
   { 
	 DetachControl()
	 MovieCrop.turnOn()
	 
	 T = 0;
	 
	 goNorth(WalkList[0],4)
	 goNorth('Bossy',2)
	 waitPlease('Bossy',2)
	 
	 QueuePersonScript(WalkList[0],"Talk_Window(talkSet[8][5], Char[1].portrait)",false)
   QueuePersonScript(WalkList[0],"Talk_Window(talkSet[8][6], BossPort, 1) ",false)
   QueuePersonScript(WalkList[0],"Talk_Window(talkSet[8][7], Char[0].portrait)",false)
   QueuePersonScript(WalkList[0],"Talk_Window(talkSet[8][8], BossPort, 1)",false)

   QueuePersonScript(WalkList[0],"fightIntro(900, true)", false)
   QueuePersonScript(WalkList[0],"event17b()",false)  
   }
}

function event17b()
{
returnControl(WalkList[0])
ClearPersonCommands('Bossy')
DestroyPerson ('Bossy')
T = 0
MovieCrop.turnOff()
ActData.EventsTriggers[17] = true
}

function OLDevent18() //From the Demo...
{
 var talk1 = "Well, You've reached the end of Trial and Error Demo 3."
 var talk2 = "I hope you had fun."
 var talk3 = "Thank you for Playing"
 
 if ( ActData.EventsTriggers[18] == false)
  {
   Talk_Window(talk1, Char[1].portrait);
   eatKey()   
   Talk_Window(talk2,Char[0].portrait);
   eatKey()
   sleepySong.play(0)   
   Talk_Window(talk3, Char[0].portrait);
   eatKey()
  
   ActData.EventsTriggers[18] = true
 }
}

function event18()
{
 var talk1 = "This is the second tablet. Let's take it back to the king."
 var talk2 = "We can use this feather to return to the castle instantly."
 
 if ( ActData.EventsTriggers[18] == false)
  {
		 Talk_Window(talkSet[8][9], Char[1].portrait);
   eatKey()   
		 Talk_Window(talkSet[8][10], Char[0].portrait,1);
   eatKey()   
		 Talk_Window(talkSet[8][11], Char[2].portrait,1);
   eatKey()   
     Talk_Window(talkSet[8][12], Char[1].portrait);
   eatKey()   
     Talk_Window(talkSet[8][13], Char[2].portrait,1);
   eatKey()   
		 Talk_Window(talkSet[8][14], Char[0].portrait,1);
   eatKey()   
     Talk_Window(talkSet[8][15], Char[1].portrait);
   eatKey()   
     Talk_Window(talkSet[8][16], Char[2].portrait,1);
   eatKey()   
     Talk_Window(talkSet[8][17], Char[0].portrait,1);
   eatKey()   
      
   ActData.EventsTriggers[18] = true
 }
}

function event19()
{
 var talk1 = "Excellent work. Now, the third tablet can be found on an island to the west. "
 + "North of the tower, you'll find a cave connecting our two islands. I don't know the "
 +"exact location of the tablet, so once you reach the island, you'll have to search for it."
 
 var KingPort = "port12.png"
 
 if ( ActData.EventsTriggers[19] == false)
  {
   Talk_Window(talkSet[9][0], KingPort);
    eatKey() 
   Talk_Window(talkSet[9][1], Char[1].portrait,1);
    eatKey()   
   Talk_Window(talkSet[9][2], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][3], Char[1].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][4], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][5], Char[1].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][6], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][7], Char[1].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][8], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][9], Char[1].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][10], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][11], Char[1].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][12], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][13], Char[1].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][14], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][15], Char[1].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][16], KingPort);
    eatKey()         
   Talk_Window(talkSet[9][17], Char[0].portrait,1);
    eatKey()         
   Talk_Window(talkSet[9][18], KingPort);
    eatKey()
	OpenGoldChest(500) 
   Talk_Window(talkSet[9][19], Char[0].portrait,1);
    eatKey() 
        
   ActData.EventsTriggers[19] = true
 }
}

//---------------------


function event20()
{
 var talk1 = "This one looks tough."
 if ( ActData.EventsTriggers[20] == false)
   { 
    Talk_Window(talk1, Char[2].portrait)
    fightIntro(902, true)
    
    DestroyPerson ('Earth Beast')
		T = 0
		ActData.EventsTriggers[20] = true  
   }
}


function event24TileChanges() //If event 24 has occurs, some tiles and Beslans dad are removed.
{
 if ( ActData.EventsTriggers[24] == true)
 {
   SetTile(30, 23, 0, 2) ;
   SetTile(30, 24, 0, 2) ;
   SetTile(30, 25, 0, 2) ;
 
   DestroyPerson ("BeslansDad");
 }
}

function event24()//freeing Beslan's dad.
{
 DadPort = "port9.png"
 BlankPort = "nothing.png"
  if ( ActData.EventsTriggers[24] == false)
   { 
    Talk_Window(XtalkSet[0][0], DadPort,1);
    eatKey()
    
   rockCrashSound.play(0);
      
   Talk_Window(XtalkSet[0][13], BlankPort);
    eatKey()  
    
    
   SetTile(30, 23, 0, 2) ;
   SetTile(30, 24, 0, 2) ;
   SetTile(30, 25, 0, 2) ;
   
   //goWest ("BeslansDad",1)
    //  QueuePersonScript(WalkList[0], " Talk_Window(XtalkSet[0][1], Char[1].portrait)", false)   
   

   Talk_Window(talkSet[10][0], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][1], Char[1].portrait);
    eatKey()      
   Talk_Window(talkSet[10][2], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][3], Char[2].portrait);
    eatKey() 
   Talk_Window(talkSet[10][4], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][5], Char[1].portrait);
    eatKey()     
   Talk_Window(talkSet[10][6], DadPort,1);
    eatKey()      
   Talk_Window(talkSet[10][7], Char[1].portrait);
    eatKey()  
   Talk_Window(talkSet[10][8], DadPort,1);
    eatKey() 
   Talk_Window(talkSet[10][9], Char[0].portrait);
    eatKey()  
   Talk_Window(talkSet[10][10], DadPort,1);
    eatKey()      
    //------
    Talk_Window(talkSet[10][11], Char[2].portrait);
    eatKey()  
   Talk_Window(talkSet[10][12], DadPort,1);
    eatKey()      
   Talk_Window(talkSet[10][13], Char[1].portrait);
    eatKey()  
   Talk_Window(talkSet[10][14], DadPort,1);
    eatKey() 
   Talk_Window(talkSet[10][15], Char[2].portrait);
    eatKey()  
   Talk_Window(talkSet[10][16], DadPort,1);
    eatKey()     
   Talk_Window(talkSet[10][17], Char[1].portrait);
    eatKey()      
   Talk_Window(talkSet[10][18], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][19], Char[2].portrait);
    eatKey() 
   Talk_Window(talkSet[10][20], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][21], Char[0].portrait);
    eatKey()  
   //------       
   Talk_Window(talkSet[10][22], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][23], Char[2].portrait);
    eatKey()      
   Talk_Window(talkSet[10][24], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][25], BlankPort);
    eatKey()
   
   addItem(Itemlist[63],5); //RECEIVE Teh CHUTNEYS!
   
   Talk_Window(talkSet[10][26], DadPort,1);
    eatKey()  
   Talk_Window(talkSet[10][27], Char[1].portrait);
    eatKey()     
   Talk_Window(talkSet[10][28], DadPort,1);
    eatKey()      
   Talk_Window(talkSet[10][29], Char[0].portrait);
    eatKey()  
   Talk_Window(talkSet[10][30], DadPort,1);
    eatKey()  
   //------

//BeslansDad
 SetPersonSpeed("BeslansDad", 3)
 IgnorePersonObstructions("BeslansDad", 1)
 goNorthwest("BeslansDad",2)
 goWest("BeslansDad",3) 
 goNorthwest("BeslansDad",1) 
 //goWest("BeslansDad",3) 
 EventCatchUp("BeslansDad")
 DestroyPerson ("BeslansDad");
   
   ActData.EventsTriggers[24] = true  
 }
}

function ForestAttackEvent()
{
 Bandits = new Array();
 
 Bandits[0] =  new Object;
 Bandits[0].Port = "port10.png"
 Bandits[0].talk = "Hey!!"
//--------------------
 
 BurnLayer.turnOn()
 
 NoSaving = true
 
 MakeMapPeople("bandit1", "thieves.rss", 1600,1400, 1,"bandit" )
 MakeMapPeople("bandit2", "thieves.rss", 1240,1700, 1,"bandit" )
 MakeMapPeople("bandit3", "thieves.rss", 1500,2000, 1,"bandit" )
 MakeMapPeople("bandit4", "thieves.rss", 1840,2000, 1,"bandit" )
}

function firstBanditsTalk()
{
 Talk_Window(talkSet[11][0], Bandits[0].Port);
   eatKey()  
 Talk_Window(talkSet[11][1], Char[0].portrait,1);
   eatKey()  
 Talk_Window(talkSet[11][2], Bandits[0].Port);
   eatKey()  
 Talk_Window(talkSet[11][3], Char[0].portrait,1);
   eatKey()  
}

function touchAttack()
{
 with (Bandits[0])
 {  
	 Talk_Window(talk, Port)
   fightIntro(905);
   DestroyPerson (GetCurrentPerson() );
   thiefCounter.count++   }
}

function MakeMapPeople(name,spriteset,x,y, layer, type, persist )
{
 randoMove = "RandomMove(GetCurrentPerson() )" 
 
 if (persist == true)
 { CreatePerson(name, spriteset, false) }
 else
 { CreatePerson(name, spriteset, true) }

 SetPersonX(name, x)
 SetPersonY(name, y)
 SetPersonLayer(name, layer)
 
 if (type == "bandit")
 {  
  SetPersonScript(name, SCRIPT_COMMAND_GENERATOR, randoMove) 
  SetPersonScript(name, SCRIPT_ON_ACTIVATE_TOUCH, "touchAttack()") 
 }
}

function clearForestTownPosts()
{

    //Posts near Delanu.
    SetTile(26, 15, 1, 0) ;
    SetTile(27, 15, 1, 0) ;
    SetTile(28, 15, 1, 0) ;
    
    SetTile(26, 14, 1, 0) ;
    SetTile(27, 14, 1, 0) ;
    SetTile(28, 14, 1, 0) ;
    
    SetTile(26, 15, 3, 0) ;
    SetTile(27, 15, 3, 0) ;
    SetTile(28, 15, 3, 0) ;
    
    SetTile(26, 14, 3, 0) ;
    SetTile(27, 14, 3, 0) ;
    SetTile(28, 14, 3, 0) ;
    
    
    //Posts at entrance.
    SetTile(0, 32, 1, 0) ;
    SetTile(0, 33, 1, 0) ;
    SetTile(0, 34, 1, 0) ;
    SetTile(0, 35, 1, 0) ;
    SetTile(0, 36, 1, 0) ;
    SetTile(0, 37, 1, 0) ;

     

}

function event26()
{
 if (ActData.EventsTriggers[26] == false)
 {
	 if (thiefCounter.count >= 5)
   {
    Talk_Window( "I'll use water magic to clear the way.", Char[1].portrait);
    eatKey()
    
		clearForestTownPosts()
    
    ActData.EventsTriggers[26] = true;
   }
	 else 
   {
    Talk_Window("We can't get through here easily, lets help the villagers first!", Char[2].portrait);
    eatKey()
   }
 }
}

function event27()
{
 if (ActData.EventsTriggers[27] == false)
 {
  
  Talk_Window( talkSet[11][4], Char[0].portrait);
  eatKey()
  Talk_Window( talkSet[11][5], Char[2].portrait);
  eatKey()
  Talk_Window( talkSet[11][6], Char[1].portrait);
  eatKey()
  Talk_Window( talkSet[11][7], Char[0].portrait);
  eatKey()
  
  
  ActData.EventsTriggers[25] = true;
  ActData.EventsTriggers[26] = true;
  ActData.EventsTriggers[27] = true;
  
  goNorth( WalkList[0],0.5)
  EventCatchUp(WalkList[0])


  fightIntro(904, true);
  DestroyPerson ("BanditBoss" )
  UpdateMapEngine()
  RenderMap()
  FlipScreen();


 Delay(300)

 InterludeScreen = new faderObject;
 InterludeScreen.setDraw(DrawInterlude1)
 //IntroScreen.setTime(60) //1sec at 60fps...
 InterludeScreen.fadeTime = 1000
 
 InterludeScreen.FadeIn()
 WaitforEnterKey();
 BurnLayer.turnOff();
 
 for (var j = 0; j < Ally.length; j++)//Delanu leaves party
  {
   if (Ally[j].name == "Delanu")
    {Ally.splice(j,1)}
  }  
 
 NoSaving = false
 
 
 Warp('forest inside 04.rmp', 615,800,3, true)
  //InterludeScreen.FadeOut()
 
 }
}

function DrawInterlude1()
{
  //ApplyColorMask(fader)
  MyStyle.drawCenteredText( 400,300, talkSet[12][0]);
  MyStyle.drawCenteredText( 400,320, talkSet[12][1]);
 // font.drawTextBox(70,270,660,600, 5, 
}

function event28()
{
 DelanuPort = "port15.png"
 Talk_Window(XtalkSet[1][10], DelanuPort); //temp Dialogue...
  eatKey()  
 Talk_Window(XtalkSet[1][11], Char[0].portrait,1);
  eatKey()  
 Talk_Window(XtalkSet[1][12], DelanuPort);
  eatKey()  
 Talk_Window(XtalkSet[1][13], Char[1].portrait,1);
  eatKey()
 Talk_Window(XtalkSet[1][14], Char[0].portrait,1);
  eatKey()  
 Talk_Window(XtalkSet[1][15], DelanuPort);
  eatKey()  
 //-------------------
 Talk_Window(talkSet[13][0], Char[1].portrait);
  eatKey()  
 Talk_Window(talkSet[13][1], DelanuPort,1);
  eatKey()  
  ActData.EventsTriggers[28] = true;
}



function event29()  //Asteral Plane ritual...
{
 if (ActData.EventsTriggers[29] == false)
 {
   DelanuPort = "port15.png"
   //Talk_Window(XtalkSet[1][18], DelanuPort);
	 Talk_Window(talkSet[13][2], DelanuPort);
   eatKey()
 
   var Result = YesNo()
 
   if (Result == true)
   {          
     //Talk_Window(XtalkSet[1][20], DelanuPort);
     
     Talk_Window(talkSet[13][3], Char[1].portrait,1);
			eatKey()  
		 Talk_Window(talkSet[13][4], DelanuPort);
			eatKey()  
     Talk_Window(talkSet[13][5], Char[0].portrait,1);
			eatKey()  
		 Talk_Window(talkSet[13][6], DelanuPort);
			eatKey()  
     Talk_Window(talkSet[13][7], Char[2].portrait,1);
			eatKey()  
		 Talk_Window(talkSet[13][8], DelanuPort);
			eatKey()  
		 Talk_Window(talkSet[13][9], Char[0].portrait,1);
			eatKey()  	
						     
     eatKey() 
     ActData.EventsTriggers[29] = true;
     
     fadeOut(MainMusic,50)
     Teleport.Activate("astral.rmp")
     //Warp("astral.rmp")
   }
   else
   {
     Talk_Window(XtalkSet[1][19], DelanuPort);
     eatKey() 
   }
   
 }
}


//-
//-------------------------------------------------------------------


function Catchup()
{
 RenderMap()
 FlipScreen();
 UpdateMapEngine()
}

//-------------------------------------townspeople-----------------------------------------
//-----------------------------------------------------------------------------------------

//-----------------Townspeople of Odoro Town---------------------------------------------------------
function Town01People() 
{
 MapPeople[0] =  new Object;//townsfolk1
 MapPeople[0].Port= "port9.png"
 MapPeople[0].talk = talkSet[2][4]
 
 MapPeople[1] =  new Object;//townsfolk2
 MapPeople[1].Port= "port7.png"
 MapPeople[1].talk = talkSet[2][5] 
 
 MapPeople[2] =  new Object;//townsfolk3
 MapPeople[2].Port= "port8.png"
 MapPeople[2].talk = talkSet[2][6]
 
 MapPeople[3] =  new Object;//BlackSmith
 MapPeople[3].Port= "port7.png"
 MapPeople[3].talk = talkSet[2][0]
 MapPeople[3].talk2 = talkSet[2][1]
 
 MapPeople[4] =  new Object;//Guard-------
 MapPeople[4].Port= "port11.png"
 MapPeople[4].talk = "Good luck on your journey."
 
 MapPeople[5] =  new Object;//Herbalist
 MapPeople[5].Port= "port4.png"
 MapPeople[5].talk =  talkSet[2][2]
 MapPeople[5].talk2 =  talkSet[2][3]
 
 MapPeople[6] =  new Object;//Innkeeper.
 MapPeople[6].Port= 'port13.png'
 MapPeople[6].talk = "Looking to rest?"
 MapPeople[6].cost = 10
}


//-----------------Townspeople of Nishi Castle----------------------------------------------------------
function Castle01People() 
{
 MapPeople[0] =  new Object;
 MapPeople[0].Port= "port9.png"
 MapPeople[0].talk = talkSet[7][1]
 //"Wow! You came through the dark forest? We haven't seen anyone come through there in a long time."

 MapPeople[1] =  new Object;
 MapPeople[1].Port= "port8.png"
 MapPeople[1].talk = talkSet[7][0]
 //"Things are pretty tense around here. Rumour has it there's fighting up north."

 MapPeople[2] =  new Object;
 MapPeople[2].Port= "port6.png"
 MapPeople[2].talk = talkSet[7][13]
 //

 MapPeople[3] =  new Object;
 MapPeople[3].Port= "port11.png"
 MapPeople[3].talk = talkSet[7][2] 
 //"Up here, on the walls, we can see anyone coming from a long way off. If the fighting comes here, this castle won't fall easily."

 MapPeople[4] =  new Object;
 MapPeople[4].Port= "port11.png"
 MapPeople[4].talk = talkSet[7][11] 
 //"Don't bother me. I'm on guard duty. "

 MapPeople[5] =  new Object;
 MapPeople[5].Port= "port11.png"
 MapPeople[5].talk = talkSet[7][12] 
 //"Cain is our best knight. In addition to being a skilled fighter, she has the power to heal."

 MapPeople[6] =  new Object;
 MapPeople[6].Port= "port6.png"
 MapPeople[6].talk = talkSet[7][4] 
 //"Nishi Castle is really strong!"
}

function InsideCastle01People() //people Inside Nishi Castle.
{
 MapPeople[0] =  new Object;
 MapPeople[0].Port= "port11.png"
 MapPeople[0].talk = talkSet[7][8] 

 MapPeople[1] =  new Object;
 MapPeople[1].Port= "port11.png"
 MapPeople[1].talk = talkSet[7][9]

 MapPeople[2] =  new Object;
 MapPeople[2].Port= "port11.png"
 MapPeople[2].talk = talkSet[7][5] 

 MapPeople[3] =  new Object;
 MapPeople[3].Port= "port11.png"
 MapPeople[3].talk = talkSet[7][6]

 MapPeople[4] =  new Object;
 MapPeople[4].Port= "port11.png"
 MapPeople[4].talk = talkSet[7][7]

 MapPeople[5] =  new Object;
 MapPeople[5].Port= "port11.png"
 MapPeople[5].talk = talkSet[7][10]

 MapPeople[6] =  new Object;
 MapPeople[6].Port= "port8.png"
 //MapPeople[6].talk = "The old temple is full of spirits, I've heard. Be careful if you go there."
 MapPeople[6].talk = talkSet[7][3] 
 
 MapPeople[7] =  new Object; //the King
 MapPeople[7].Port= "port12.png"
 MapPeople[7].talk1 = talkSet[6][45]
 MapPeople[7].talk2 = talkSet[9][20]
 
 

 MapPeople[8] =  new Object;
 MapPeople[8].Port= "port4.png"
 MapPeople[8].talk = talkSet[7][14] 
 MapPeople[8].talk2 = talkSet[7][15]
 MapPeople[8].talk3 = talkSet[7][16]

 MapPeople[9] =  new Object;
 MapPeople[9].Port= "port6.png"
 MapPeople[9].talk = talkSet[7][17]
 MapPeople[9].talk2 = talkSet[7][18]

}

function Town03People() //FOREST Town....
{
 MapPeople[0] =  new Object;//BlackSmith
 MapPeople[0].Port= "port16.png"
 MapPeople[0].talk = "Everyone's suddenly looking for a weapon...."                          
 
 MapPeople[1] =  new Object;//Herbalist
 MapPeople[1].Port= "port7.png"
 MapPeople[1].talk = "We druids are masters of herb lore."
 
 MapPeople[2] =  new Object;//Inn
 MapPeople[2].Port= "port6.png"
 MapPeople[2].talk = "Welcome to our inn."
 MapPeople[2].cost = 45
 //-----------------------------------------------------
 MapPeople[3] =  new Object;//townsfolk 01
 MapPeople[3].Port= "port9.png"
 if (ActData.EventsTriggers[28] == false)
 { MapPeople[3].talk = "Ah!! They're burning the town!"}
 else
 { MapPeople[3].talk = "Thanks for helping us fight off the bandits!"   }


 
 MapPeople[4] =  new Object;//townsfolk 02
 MapPeople[4].Port= "port13.png"
 if (ActData.EventsTriggers[28] == false)
  {MapPeople[4].talk = "What the hell do they want?" }
 else
  { MapPeople[4].talk = "I'm suprised you found our village. It's in the woods and all." }
 
 
 MapPeople[5] =  new Object;//townsfolk 03
 MapPeople[5].Port= "port11.png"
 if (ActData.EventsTriggers[28] == false)
 { MapPeople[5].talk = "help!"}
 else
 { MapPeople[5].talk = "To the northwest is a ruined castle. It used to be a noble place, but it was besieged "
                     +"and destroyed by enemy forces long ago. It's become corrupted and is now the "
                     +"home of demons and the undead!"
 }


 
 MapPeople[6] =  new Object;//townsfolk 04
 MapPeople[6].Port= 'port4.png'
 if (ActData.EventsTriggers[28] == false)
 { MapPeople[6].talk = "help us fight off the bandits!"}
 else
 { MapPeople[6].talk = "Delanu has mystic powers. Sometimes she can see things in dreams. Her powers have helped "
                     +"to protect this village."
 }
 
 
 MapPeople[7] =  new Object;//Delanu
 MapPeople[7].Port= 'port15.png'
 if (ActData.EventsTriggers[29] == false)
 { MapPeople[7].talk = ". . ."}
 else
 { MapPeople[7].talk = ". . ." }
}

function Interlude01Draw()
{
  UpdateMapEngine()
  RenderMap()

}

function Interlude01Pre()
{
 MakeMapPeople("Boss", "thieves3.rss", 1050,3000, 2,"none" )
 SetPersonDirection("Boss", "east" )
 
 MakeMapPeople("bandit1", "thieves.rss", 1180,3000, 2,"none")
 SetPersonDirection("bandit1", "west" )
 SetPersonSpeed("bandit1", 3)
 
 MakeMapPeople("bandit2", "thieves.rss", 1700,2680, 2,"none")
 SetPersonSpeed("bandit2", 3)

}

function Interlude01()//Scene in the woods, after Heros stole 1st tablet.
{
 if (ActData.EventsTriggers[32] == false)
 {
  DetachControl()
  Area.Grab()

  ForestFade = new faderObject;
  ForestFade.setDraw(Interlude01Draw)
  ForestFade.fadeTime = 2000
 
  ForestFade.FadeOut()
  
  Camp.finish() 
  Camp.stage == 3  
 
  Warp("forest01.rmp",1175,2960 ,0, true)
 
  goSouthwest("bandit2",5)
  goWest("bandit2",2)
  waitPlease('Boss',5,3)
  waitPlease('bandit1',5,3)
  QueuePersonCommand("Boss", COMMAND_FACE_EAST, 0)
  QueuePersonCommand("bandit1", COMMAND_FACE_EAST, 0)
 
  QueuePersonScript("bandit2", "Interlude01b()", false)
 }
}

function Interlude01b()
{
 var thiefport = 'port10.png'
 var Bossport = 'port17.png'
 
  Talk_Window(talkSet[4][0], thiefport);
		eatKey()
  Talk_Window(talkSet[4][1], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][2], thiefport);
		eatKey()	
  Talk_Window(talkSet[4][3], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][4], thiefport);
		eatKey()
  Talk_Window(talkSet[4][5], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][6], thiefport);
		eatKey()
  Talk_Window(talkSet[4][7], Bossport,1);
		eatKey()

 MakeMapPeople("bandit3", "thieves.rss", 750,3060, 2,"none" )
 SetPersonSpeed("bandit3", 3)
 goEast("bandit3",4)
 
 waitPlease('Boss',2,3)
 waitPlease('bandit1',2,3)
 QueuePersonCommand("Boss", COMMAND_FACE_WEST, 0)
 QueuePersonCommand("bandit1", COMMAND_FACE_WEST, 0)
 QueuePersonScript("bandit3", "Interlude01c()", false)

}
function Interlude01c()
{
 var thiefport = 'port10.png'
 var Bossport = 'port17.png'
 
  Talk_Window(talkSet[4][8], thiefport);
		eatKey()
  Talk_Window(talkSet[4][9], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][10], thiefport);
		eatKey()	
  Talk_Window(talkSet[4][11], Bossport,1);
		eatKey()


 MakeMapPeople("bandit4", "thieves.rss", 1570,3060, 2,"none" )
 SetPersonSpeed("bandit4", 3)
 goNorthwest("bandit4",1) 
 goWest("bandit4",2)
 
 waitPlease('Boss',3,3)
 waitPlease('bandit1',3,3)
 QueuePersonCommand("Boss", COMMAND_FACE_EAST, 0)
 QueuePersonCommand("bandit1", COMMAND_FACE_EAST, 0)
 QueuePersonScript("bandit4", "Interlude01d()", false)
}

function Interlude01d()
{
 var thiefport = 'port10.png'
 var Bossport = 'port17.png'
 
  Talk_Window(talkSet[4][12], thiefport);
		eatKey()
  Talk_Window(talkSet[4][13], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][14], thiefport);
		eatKey()	
  Talk_Window(talkSet[4][15], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][16], thiefport);
		eatKey()
  Talk_Window(talkSet[4][17], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][18], thiefport);
		eatKey()
  Talk_Window(talkSet[4][19], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][20], thiefport);
		eatKey()
  Talk_Window(talkSet[4][21], Bossport,1);
		eatKey()

 QueuePersonCommand("bandit2", COMMAND_FACE_WEST, 0)		
		
  Talk_Window(talkSet[4][22], thiefport);
		eatKey()
  Talk_Window(talkSet[4][23], Bossport,1);
		eatKey()


 MakeMapPeople("Contact", "BadGuy.rss", 750,3090, 2,"none" )
 SetPersonSpeed("Contact", 1.5)
 goEast("Contact",3) 

 
 waitPlease('Boss',3,3)
 waitPlease('bandit1',3,3)
 QueuePersonCommand("Boss", COMMAND_FACE_WEST, 0)
 QueuePersonCommand("bandit1", COMMAND_FACE_WEST, 0)
 QueuePersonScript("Contact", "Interlude01e()", false)
}

function Interlude01e()
{
 var thiefport = 'port10.png'
 var Bossport = 'port17.png'
 var Contactport = 'port18.png'
 
  Talk_Window(talkSet[4][24], Contactport);
		eatKey()
  Talk_Window(talkSet[4][25], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][26], Contactport);
		eatKey()	
  Talk_Window(talkSet[4][27], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][28], Contactport);
		eatKey()
  Talk_Window(talkSet[4][29], Bossport,1);
		eatKey()
  Talk_Window(talkSet[4][30], Contactport);
		eatKey()
  Talk_Window(talkSet[4][31], Bossport,1);
		eatKey()

goSouth("bandit1",4)
goEast("bandit2",2)
goNortheast("bandit2",3)
goWest("bandit3",4)
goEast("bandit4",4)

 
 waitPlease('Boss',3,3)
 waitPlease('Contact',2,3)
 QueuePersonScript("Contact", "Interlude01f()", false)

}

function Interlude01f()
{
  ActData.EventsTriggers[32] = true
  ForestFade.done = true
 
  

  Warp("World 01.rmp",Area.x,Area.y ,Area.layer, false)
  Delay(200)
  UpdateMapEngine()
  RenderMap()
  returnControl(WalkList[0] )
  event13b()
}

function JoinScreen(CharNum)
{
 timer1= new timerObject(3000);
 PoseyW = (400 - who.charPose.width/2)
 PoseyH = (200 - who.charPose.height/2)
 dramaticSound.play(0);
 Delay(500)
 with (timer1)  
 {   
	while (now < end) 
	{
		UpdateMapEngine()
		RenderMap()
		MyStyle.window.drawWindow (50, 400, 650, 150);
		MyStyle.drawCenteredText (400,500,CharRoot[CharNum].name + " joined!", White, 2);
		CharRoot[CharNum].charPose.blit(PoseyW,PoseyH);
		
    update()
    FlipScreen();
   }
 }
}

function GetTablet3() //get the 3rd tablet, and see demo ending.
{
 if (ActData.EventsTriggers[48] == false)
  {
   OpenChest(61,1)
		 Talk_Window(XtalkSet[2][0], Char[0].portrait);
   eatKey()   
		 Talk_Window(XtalkSet[2][1], Char[1].portrait,1);
   eatKey()   
		 Talk_Window(XtalkSet[2][2], Char[2].portrait);
   eatKey()   
   DestroyPerson ('Tablet')
   
   
   
   
   
   
//------------------------------------------
/*
 var talk1 = "Well, You've reached the end of Trial and Error Demo 4."
 var talk2 = "I hope you had fun."
 var talk3 = "Thank you for Playing"
 
   Talk_Window(talk1, Char[1].portrait);
   eatKey()   
   Talk_Window(talk2,Char[0].portrait);
   eatKey()
   sleepySong.play(0)   
   Talk_Window(talk3, Char[0].portrait);
   eatKey()
*/   
   
   DemoEnding()
//------------------------------------------
   Teleport.Activate()
   ActData.EventsTriggers[48] = true
   
   
   //RenderMap()
   //GrabScreen();
   
 }
}

function OutsideEarthCaveEvent()
{
 var text1 = "It's gonne be a long way to the druid's village. Maybe we should rest and use a tent."

if ( ActData.EventsTriggers[49] == false)
 {
   Talk_Window(text1, Char[1].portrait);
    eatKey() 
   ActData.EventsTriggers[49] = true
 } 
}


function EnterBurningTownEvent()
{
 var text1 = "Shit! The bandits are here already and they're attacking the town!"
 var text2 = "C'mon! We've got to help the townspeople!"
if ( ActData.EventsTriggers[50] == false)
 {
   Talk_Window(text1, Char[0].portrait);
    eatKey() 
   Talk_Window(text2, Char[2].portrait,1);
    eatKey() 
   ActData.EventsTriggers[50] = true
 } 
}


function RunAwayfromForestTownEvent()
{
 var text1 = "Aldric! Now's not the time to be running away!"
if ( ActData.EventsTriggers[28] == false)
 {
   Talk_Window(text1, Char[2].portrait);
    eatKey() 
 } 
}

function Event51()
{
 if ( ActData.EventsTriggers[51] == false) 
 {  
  ActData.EventsTriggers[51] = true
  Event51b()
  spookySound.play(0)
 }
}


function Event51b()
{
 if ( ActData.EventsTriggers[51] == true)
 {  
  SetTile(24, 37, 2, 212) ; 
  SetTile(27, 37, 2, 212) ; 
 }
}


function Event52()
{
 if ( ActData.EventsTriggers[52] == false) 
 {  
  ActData.EventsTriggers[52] = true
  Event52b()
  spookySound.play(0)
 }
}


function Event52b()
{
 if ( ActData.EventsTriggers[52] == true)
 {  
  SetTile(24, 34, 2, 212) ; 
  SetTile(27, 34, 2, 212) ; 
 }
}

function Event53()
{
 if ( ActData.EventsTriggers[53] == false) 
 {  
  ActData.EventsTriggers[53] = true
  Event53b()
  spookySound.play(0)
 }
}


function Event53b()
{
 if ( ActData.EventsTriggers[53] == true)
 {  
  SetTile(24, 31, 2, 212) ; 
  SetTile(27, 31, 2, 212) ; 
 }
}

function DemoEnding() //ending Jan 2005
{
 story = new Object;
 story.Image =  LoadImage("Intro.png");
 story.text1 = "With three of the tablets gathered, our Heroes are well into their quest. "
				+	"Unfortunately, this is the end of Trial and Error Demo 4. Join us next time, "
				+ "for what will hopefully be the final version of the game. \n"
			  +"Thank you for playing!! \n\n"

	+"Trial and Error was created by:\n"
	+"Dennis Rosenfeld (project lead, code, art)\n"
	+"Nick Carrier (Story, some sound FX)\n"
	+"Pete Diamond (Monster Art)\n"
	+"Jon Bell (Music) \n\n"

  +"I would like to thank Aegis and Flik for developing sphere, listening to all my feature "
  +"requests, and fixing all those darned engine bugs. I would also like to thank the sphere "
  +"community for all their support, and all those code snippets I borrowed. (So if you want "
  +"your name in these credits, contact me!)"

 story.text2 = "Press any key to keep playing (just for fun!)"

MainMusic.stop();
MainMusic = RoadSong
MainMusic.play(0);

 IntroScreen = new faderObject;
 IntroScreen.setDraw(DrawIntroB)
 //IntroScreen.setTime(60) //1sec at 60fps...
 IntroScreen.fadeTime = 2000
 
 IntroScreen.FadeIn()
 WaitforEnterKey();
 IntroScreen.FadeOut()
}